/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.api.constants.GuiComponentType;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.gui.IGuiEntity;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;
import noppes.npcs.controllers.PlayerSkinController;

public class CustomGuiEntityWrapper
extends CustomGuiComponentWrapper
implements IGuiEntity {
    public NBTTagCompound entityNbt = null;
    IEntity<?> entity;
    float scale;
    boolean hasBorder = false;
    boolean showArmor = true;
    public int rotType = 0;
    public int rotYaw = 0;
    public int rotPitch = 0;

    public CustomGuiEntityWrapper() {
        this(-1, 0, 0, null);
    }

    public CustomGuiEntityWrapper(int id, int x, int y, IEntity<?> entity) {
        this.setId(id);
        this.setPos(x, y);
        this.entity = entity;
        this.scale = 1.0f;
    }

    @Override
    public CustomGuiEntityWrapper fromNBT(NBTTagCompound nbt) {
        super.fromNBT(nbt);
        this.setScale(nbt.func_74760_g("Scale"));
        this.hasBorder = nbt.func_74767_n("HasBorder");
        this.showArmor = nbt.func_74767_n("ShowArmor");
        this.entityNbt = nbt.func_74775_l("Entity");
        if (this.entityNbt.func_150296_c().isEmpty()) {
            this.entity = null;
        }
        this.rotType = nbt.func_74762_e("RotationType");
        this.rotYaw = nbt.func_74762_e("RotationYaw");
        this.rotPitch = nbt.func_74762_e("RotationPitch");
        return this;
    }

    @Override
    public IEntity<?> getEntity() {
        return this.entity;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public int getType() {
        return GuiComponentType.ENTITY.get();
    }

    @Override
    public boolean hasBorder() {
        return this.hasBorder;
    }

    @Override
    public boolean isShowArmorAndItems() {
        return this.showArmor;
    }

    @Override
    public void setBorder(boolean hasBorder) {
        this.hasBorder = hasBorder;
    }

    @Override
    public void setEntity(IEntity<?> entity) {
        this.entity = entity;
    }

    @Override
    public void setScale(float scale) {
        if (scale < 0.0f) {
            scale *= -1.0f;
        }
        this.scale = scale;
    }

    @Override
    public void setShowArmorAndItems(boolean show) {
        this.showArmor = show;
    }

    @Override
    public NBTTagCompound toNBT(NBTTagCompound nbt) {
        super.toNBT(nbt);
        nbt.func_74776_a("Scale", this.scale);
        nbt.func_74757_a("HasBorder", this.hasBorder);
        nbt.func_74757_a("ShowArmor", this.showArmor);
        this.entityNbt = new NBTTagCompound();
        if (this.entity != null && this.entity.getMCEntity() != null) {
            this.entityNbt.func_74757_a("IsPlayer", this.entity instanceof IPlayer);
            if (this.entity instanceof IPlayer) {
                this.entity.getMCEntity().func_189511_e(this.entityNbt);
                if (PlayerSkinController.getInstance().playerTextures.containsKey(this.entity.getMCEntity().func_110124_au())) {
                    this.entityNbt.func_74782_a("SkinData", (NBTBase)PlayerSkinController.getInstance().getNBT(this.entity.getMCEntity().func_110124_au()));
                }
            } else {
                this.entity.getMCEntity().func_184198_c(this.entityNbt);
            }
        }
        nbt.func_74782_a("Entity", (NBTBase)this.entityNbt);
        nbt.func_74768_a("RotationType", this.rotType);
        nbt.func_74768_a("RotationYaw", this.rotYaw);
        nbt.func_74768_a("RotationPitch", this.rotPitch);
        return nbt;
    }

    @Override
    public int getRotationType() {
        return this.rotType;
    }

    @Override
    public void setRotationType(int type) {
        if (type < 0) {
            type *= -1;
        }
        this.rotType = type % 3;
    }

    @Override
    public int getYaw() {
        return this.rotYaw;
    }

    @Override
    public int getPitch() {
        return this.rotPitch;
    }

    @Override
    public void setRotation(int yaw, int pitch) {
        while (yaw < 0) {
            yaw += 360;
        }
        this.rotYaw = yaw % 360;
        this.rotPitch = pitch % 91;
    }
}

